<?php

/*
 * Plugin Name: Paygenius Hosted Payment Gateway 
 * Plugin URI: https://developer.paygenius.co.za/
 * Description: Take payments on your store using Paygenius hosted interface.
 * Author: PayGenius 
 * Author URI: https://info.paygenius.co.za/
 * Version: 1.1.00
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: paygenius-hosted-payment-gateway
 */
if (!defined('ABSPATH')) {
    exit;
}

if (! defined('PAYGENIUS_REDIRECT_FILE')) {
    define('PAYGENIUS_REDIRECT_FILE', __FILE__);
}
if (! defined('PAYGENIUS_REDIRECT_DIR')) {
    define('PAYGENIUS_REDIRECT_DIR', plugin_dir_path(__FILE__));
}
if (! defined('PAYGENIUS_REDIRECT_URL')) {
    define('PAYGENIUS_REDIRECT_URL', plugin_dir_url(__FILE__));
}


// Initialize the plugin
add_action('plugins_loaded', 'init_paygenius_redirect');

function init_paygenius_redirect()
{
    require_once(__DIR__ . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'PayGenius' . DIRECTORY_SEPARATOR . 'WebClient.php');
    require_once(__DIR__ . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'Paygenius_Hosted_Payment_Gateway_Redirect.php');

    add_filter('woocommerce_payment_gateways', 'add_paygenius_redirect');

    if (class_exists('\Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType')) {
        add_action(
            'woocommerce_blocks_payment_method_type_registration',
            function ($payment_method_registry) {
                require_once(__DIR__ . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'blocks' . DIRECTORY_SEPARATOR . 'class-wc-paygenius-redirect-blocks.php');
                $payment_method_registry->register(new Paygenius_Hosted_Payment_Gateway_Redirect_Blocks());
            }
        );
    }
}

function add_paygenius_redirect($methods)
{
    $methods[] = 'Paygenius_Hosted_Payment_Gateway_Redirect';

    return $methods;
}
